define(['angular', 'angularMocks', 'RequestsController', 'angularUiBootstrap', 'lodash'], function(angular, mocks) {
	'use strict';

	describe("The Request controller", function () {
		var controller, 
			scope,
			state,
			q,
			modalServiceMock,
			focusServiceMock,
			connectionErrorServiceMock,
			formatterMock,
			requestsServiceMock,
			validationSummaryMock,
            activeInstitutionMock,
        	originalRequest;

		var mockedResponse = {
            status: 200,
            data: {
                id: '501',
                requestSettings:[{
                    "typeOfCare": "AUDIOLOGY",
                    "patientHistoryRequired": "",
                    "patientHistoryDuration": 0,
                    "submittedRequestLimit": 2
                }],
                customRequestSettings : [{
                    "id" : "CR1",
                    "typeOfCare" : "Express Care",
                    "submittedRequestLimit" : 0,
                    "enterpriseSubmittedRequestLimit" : 3,
                    "supported" : false,
                    "schedulingDays" : [ {
                        "day" : "MONDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "TUESDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "WEDNESDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "THURSDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "FRIDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "SATURDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "SUNDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }]
                }]
            }
        };

		beforeEach( function () {
			module('angularTemplateApp');

            originalRequest = angular.copy(mockedResponse.data);

			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain', 'focusPrimary']);
			connectionErrorServiceMock = jasmine.createSpyObj('connectionErrorService', ['showServerErrorMsg']);
			formatterMock = jasmine.createSpyObj('formatter', ['toDashCase']);
			requestsServiceMock = jasmine.createSpyObj('RequestsService', ['fetch', 'save']);
			validationSummaryMock = jasmine.createSpyObj('validationSummary', ['requiredValidate', 'clear', 'summarizeAsync', 'hasError']);
            activeInstitutionMock = {divisionName:"mock institution",childName:'501'};

			module(function($provide){
				$provide.value('modalService', modalServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('connectionErrorService', connectionErrorServiceMock);
				$provide.value('formatter', formatterMock);
				$provide.value('RequestsService', requestsServiceMock);
				$provide.value('activeInstitution', activeInstitutionMock);
			});

			inject(function($controller, $rootScope, $q, formatter) {
				scope = $rootScope.$new();

				modalServiceMock.showModal.andCallFake( function() {
					return {
						then: function(callback) { return callback(); }
					};
				} );

				requestsServiceMock.fetch.andCallFake( function() {
					var promise = $q.defer();

					promise.resolve({
						response: mockedResponse
					});

					promise.then = function(callback) { return callback(mockedResponse); };
					return promise;
				} );

				requestsServiceMock.save.andCallFake( function(data) {
					var promise = $q.defer();
					var response = {
						status: 200,
						data: data
					};
					promise.resolve({
						response: response
					});
					promise.then = function(callback) { return callback(response); };
					return promise;
				} );

				validationSummaryMock.requiredValidate.andCallFake( function(){
					return {
						then: function(callback) { return callback(); }
					};
				} );

				controller = $controller('RequestsController', {$scope: scope});

				 scope.requestForm = {
					validationSummary: validationSummaryMock,
					$setPristine: function (){},
					$setSubmitted: function (){}
				};
			});
		});

		it('should reset the request settings form to the data that was last saved', function(){
			expect(scope.request).toEqual(originalRequest);
			expect(scope.lastSavedRequest).toEqual(scope.request);

			scope.resetTypeOfCare();
			expect(scope.lastSavedRequest.requestSettings[0]).toEqual(originalRequest.requestSettings[0]);
			expect(scope.request).toEqual(scope.lastSavedRequest);
		});

        it('should reset express care form to the data that was last saved', function () {
            expect(scope.request).toEqual(originalRequest);
            expect(scope.lastSavedExpressCare).toEqual(scope.request.customRequestSettings[0]);

            scope.resetExpressCare();

            expect(scope.lastSavedExpressCare).toEqual(originalRequest.customRequestSettings[0]);
            expect(scope.request).toEqual(scope.lastSavedRequest);
        });

		it('should save the form data', function(){
			scope.request = {
				id: '501',
				requestSettings: [{
					"typeOfCare": "AUDIOLOGY",
					"patientHistoryRequired": "No",
					"patientHistoryDuration": 2,
					"submittedRequestLimit": 3
				}],
                customRequestSettings : [{
                    "id" : "CR1",
                    "typeOfCare" : "Express Care",
                    "submittedRequestLimit" : 0,
                    "enterpriseSubmittedRequestLimit" : 3,
                    "supported" : false,
                    "schedulingDays" : [ {
                        "day" : "MONDAY",
                        "canSchedule" : true,
                        "startTime" : "07:47",
                        "endTime" : "09:47"
                    }, {
                        "day" : "TUESDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "WEDNESDAY",
                        "canSchedule" : true,
                        "startTime" : "10:47",
                        "endTime" : "18:47"
                    }, {
                        "day" : "THURSDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "FRIDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "SATURDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }, {
                        "day" : "SUNDAY",
                        "canSchedule" : false,
                        "startTime" : "",
                        "endTime" : ""
                    }]
                }]
			};
			scope.save();
			expect(requestsServiceMock.save).toHaveBeenCalledWith(scope.request,'501');
			expect(modalServiceMock.showModal).toHaveBeenCalled();
			expect(validationSummaryMock.summarizeAsync).toHaveBeenCalled();
            expect(validationSummaryMock.hasError).toHaveBeenCalled();

			expect(scope.request.requestSettings[0]).toEqual({
				'typeOfCare': 'AUDIOLOGY',
				'patientHistoryRequired': 'No',
				'patientHistoryDuration': 2,
				"submittedRequestLimit": 3
			});

			expect(scope.lastSavedRequest).toEqual(scope.request);
            expect(scope.lastSavedExpressCare).toEqual(scope.request.customRequestSettings[0]);
		});
	});
});
